#include <POF/Gradient_estimator.h>

extern double ccon_gradient[n_label][MAX_n_class][MAX_batch_size];
extern double test_case_ccon_gradient[n_label][MAX_n_class][MAX_n_internal_test_case];
double ccon_gradient_square[n_label][MAX_n_class][MAX_batch_size];
double test_case_ccon_gradient_square[n_label][MAX_n_class][MAX_n_internal_test_case];

extern void flatten_ccon_gradient(int n_label, int batch_size, int n_class, double ccon_gradient_list[]);
extern void flatten_test_case_ccon_gradient(int n_label, int n_internal_test_case, int n_class, double test_case_ccon_gradient_list[]);

void flatten_ccon_gradient_square(int n_label, int batch_size, int n_class, double ccon_gradient_square_list[]) {
	for (int i = 0; i < n_label; i++) {
		for (int j = 0; j < batch_size; j++) {
			for (int k = 0; k < n_class; k++) {
				ccon_gradient_square_list[i*batch_size*n_class + j*n_class + k] = ccon_gradient_square[i][k][j];
			}
		}
	}
}
void flatten_test_case_ccon_gradient_square(int n_label, int batch_size, int n_class, double test_case_ccon_gradient_square_list[]) {
	for (int i = 0; i < n_label; i++) {
		for (int j = 0; j < batch_size; j++) {
			for (int k = 0; k < n_class; k++) {
				test_case_ccon_gradient_square_list[i*batch_size*n_class + j*n_class + k] = test_case_ccon_gradient_square[i][k][j];
			}
		}
	}
}

std::default_random_engine generator;

void exp_map(double arr[], int len, double out[]) {
	for (int i = 0; i < len; i++) out[i] = exp(arr[i]);
}

double sum_arr(double arr[], int len) {
	double sum = 0;
	for (int i = 0; i < len; i++) sum += arr[i];
	return sum;
}

void div_map(double arr[], int len, double divider, double out[]) {
	for (int i = 0; i < len; i++) out[i] = arr[i] / divider;
}

void estimate_ccon_grad(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double ccon_gradient_list[], double ccon_gradient_square_list[], int n_sample) {
	
}

void estimate_test_case_ccon_grad(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double test_case_ccon_gradient_list[], double test_case_ccon_gradient_square_list[], int n_sample) {
	
}


void estimate_grad(struct NN_data* nn_data, struct User_parameter* user_parameter, struct Indata* indata, double ccon_gradient_list[], double ccon_gradient_square_list[], double test_case_ccon_gradient_list[], double test_case_ccon_gradient_square_list[], int n_sample) {
	// // Set sample case gradient as zero.
	// for (int pm = 0; pm < n_label; pm++) {
	// 	for (int i = 0; i < nn_data->n_class; i++) ccon_gradient[pm][i] = 0;
	// }

    memset(ccon_gradient, 0, sizeof(ccon_gradient));
	memset(ccon_gradient_square, 0, sizeof(ccon_gradient_square));
	memset(test_case_ccon_gradient, 0., sizeof(test_case_ccon_gradient));
	memset(test_case_ccon_gradient_square, 0., sizeof(test_case_ccon_gradient_square));

	double xi = user_parameter->xi;
	int n_rank = user_parameter->n_rank;
	int n_internal_test_case = nn_data->n_internal_test_case;
	int batch_size = nn_data->batch_size;
	int n_class = nn_data->n_class;

    NN_data *new_nn_data(new NN_data);
    *new_nn_data = *nn_data;

	Indata *new_indata(new Indata);
	*new_indata = *indata;

    const int len = nn_data->n_class;

	for (int _ = 0; _ < n_sample; _++) {
		memset(new_nn_data->normalclass, 0, sizeof(new_nn_data->normalclass));
		memset(new_indata->normaltable, 0, sizeof(new_indata->normaltable));
		memset(new_indata->normaltable_eff, 0, sizeof(new_indata->normaltable_eff));

		for (int pm = 0; pm < n_label; pm++) {
			for (int j = 0; j < batch_size; j++) {
	        	double exp_ccon_w[MAX_n_class] {}, expsum, softmax[MAX_n_class] {};

           	 	exp_map(nn_data->ccon_w[pm][j], len, exp_ccon_w);
	        	expsum = sum_arr(exp_ccon_w, len);
	        	div_map(exp_ccon_w, len, expsum, softmax);

	        	std::discrete_distribution<int> output_distribution (softmax, softmax + len);

			    new_nn_data->normalclass[pm][j] = output_distribution(generator);
			}

			for (int j = 0; j < n_internal_test_case; j++) {
				double expsum = 0;
				for (int k = 0; k < n_class; k++) expsum += exp(nn_data->test_case_ccon_w[pm][k][j]);
				for (int i = 0; i < n_class; i++) {
					double mxi_expsum = expsum + exp(nn_data->test_case_ccon_w[pm][i][j] - xi) - exp(nn_data->test_case_ccon_w[pm][i][j]);
					double pxi_expsum = expsum + exp(nn_data->test_case_ccon_w[pm][i][j] + xi) - exp(nn_data->test_case_ccon_w[pm][i][j]);
					std::discrete_distribution<int> indicator_distribution \
					{exp(nn_data->test_case_ccon_w[pm][i][j] - xi) / mxi_expsum + 1e-9, exp(nn_data->test_case_ccon_w[pm][i][j] + xi) / pxi_expsum - exp(nn_data->test_case_ccon_w[pm][i][j] - xi) / mxi_expsum + 1e-9, 1 - exp(nn_data->test_case_ccon_w[pm][i][j] + xi) / pxi_expsum + 1e-9};
					int indicator_pair = indicator_distribution(generator);
					if (indicator_pair == 0) {
						new_indata->normaltable[pm][nn_data->ans[pm][j]][i][1]++;
						new_indata->normaltable[pm][nn_data->ans[pm][j]][i][0]++;
						new_indata->normaltable_eff[pm][i][j][1] = 1;
						new_indata->normaltable_eff[pm][i][j][0] = 1;
					}
					else if (indicator_pair == 1) {
						new_indata->normaltable[pm][nn_data->ans[pm][j]][i][1]++; // KKY to KSW!: fix indexing problem (nn_data->nn_data->ans)
						new_indata->normaltable_eff[pm][i][j][1] = 1;
					}
				}
			}
		}
		set_posterior(new_nn_data, user_parameter, new_indata);
		double approxloss_sample = calc_approx_loss(new_nn_data, new_indata, user_parameter);

		for (int pm = 0; pm < n_label; pm++) {
			for (int j = 0; j < batch_size; j++) {
				for (int i = 0; i < n_class; i++) {
					double grad = 0;

					double exp_ccon_w[MAX_n_class] {}, expsum, softmax[MAX_n_class] {};
           	 		exp_map(nn_data->ccon_w[pm][j], len, exp_ccon_w);
	        		expsum = sum_arr(exp_ccon_w, len);
	        		div_map(exp_ccon_w, len, expsum, softmax);

	                if (i == new_nn_data->normalclass[pm][j])
	                    grad += approxloss_sample; // * softmax[i] / softmax[i];
				    grad += - approxloss_sample * softmax[i]; // * softmax[output_sample] * softmax[i] / softmax[output_sample];
                    ccon_gradient[pm][i][j] += grad / n_sample;
					ccon_gradient_square[pm][i][j] += pow(grad, 2) / n_sample;
				}
			}

			for (int j = 0; j < n_internal_test_case; j++) {
				for (int i = 0; i < n_class; i++) {
					double grad = 0;
					for (int k = 0; k < n_class; k++) {
						//calculate expsum for +-xi
						double expsum = 0;
						for (int k = 0; k < n_class; k++) expsum += exp(nn_data->test_case_ccon_w[pm][k][j]);
						double mxi_expsum = expsum + exp(nn_data->test_case_ccon_w[pm][k][j] - xi) - exp(nn_data->test_case_ccon_w[pm][k][j]);
						double pxi_expsum = expsum + exp(nn_data->test_case_ccon_w[pm][k][j] + xi) - exp(nn_data->test_case_ccon_w[pm][k][j]);
						
						if (new_indata->normaltable_eff[pm][k][j][1] == 1 && new_indata->normaltable_eff[pm][k][j][0] == 1) {
							//(1,1) approxloss_sample * log(softmax(-xi))
							if (k == i) {
								grad += approxloss_sample * (1 - exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum);
							}
							else {
								grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][i][j]) / mxi_expsum;
							}
						}
						else if (new_indata->normaltable_eff[pm][k][j][1]) {
							//(0,1) approxlos_sample * log(softmax(+xi)-softmax(-xi))
							if (k == i) {
								//org
								// test_case_ccon_gradient[pm][i][j] += approxloss_sample * (1 - exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum) * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum;
								// test_case_ccon_gradient[pm][i][j] += - approxloss_sample * (1 - exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum) * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum;
								// test_case_ccon_gradient[pm][i][j] /= exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum - exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum;
								//new
								grad += approxloss_sample;
								grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum;
								grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum;
							}
							else {
								//org
								// test_case_ccon_gradient[pm][i][j] += - approxloss_sample * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) * exp(nn_data->test_case_ccon_w[pm][i][j]) / pxi_expsum / pxi_expsum;
								// test_case_ccon_gradient[pm][i][j] += approxloss_sample * exp(nn_data->test_case_ccon_w[pm][k][j] - xi) * exp(nn_data->test_case_ccon_w[pm][i][j]) / mxi_expsum / mxi_expsum;
								// test_case_ccon_gradient[pm][i][j] /= exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum - exp(nn_data->test_case_ccon_w[pm][k][j] - xi) / mxi_expsum;
								//new
								grad += approxloss_sample * exp(nn_data->test_case_ccon_w[pm][i][j]) / (expsum - exp(nn_data->test_case_ccon_w[pm][k][j]));
								grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][i][j]) / pxi_expsum;
								grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][i][j]) / mxi_expsum;
							}
						}
						else {
							//(0,0) approxloss_sample * log(1-softmax(+xi))
							if (k == i) {
								//org
								// test_case_ccon_gradient[pm][i][j] += - approxloss_sample * (1 - exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum) * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum;
								// test_case_ccon_gradient[pm][i][j] /= (1 - exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum);
								//new
								grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum;
							}
							else {
								//org
								// test_case_ccon_gradient[pm][i][j] += approxloss_sample * exp(nn_data->test_case_ccon_w[pm][k][j] + xi) * exp(nn_data->test_case_ccon_w[pm][i][j]) / pxi_expsum / pxi_expsum;
								// test_case_ccon_gradient[pm][i][j] /= (1 - exp(nn_data->test_case_ccon_w[pm][k][j] + xi) / pxi_expsum);
								//new
								grad += approxloss_sample * exp(nn_data->test_case_ccon_w[pm][i][j]) / (expsum - exp(nn_data->test_case_ccon_w[pm][k][j]));
								grad += -approxloss_sample * exp(nn_data->test_case_ccon_w[pm][i][j]) / pxi_expsum;
							}
						}
					}
					test_case_ccon_gradient[pm][i][j] += grad / n_sample; // KKY to KSW!: add parentheses
					test_case_ccon_gradient_square[pm][i][j] += pow(grad, 2) / n_sample;
				}
			}
		}
	}

    delete new_nn_data;
	delete new_indata;
	
	flatten_ccon_gradient(n_label, nn_data->batch_size, nn_data->n_class, ccon_gradient_list);
	flatten_ccon_gradient_square(n_label, nn_data->batch_size, nn_data->n_class, ccon_gradient_square_list);
	flatten_test_case_ccon_gradient(n_label, n_internal_test_case, n_class, test_case_ccon_gradient_list);
	flatten_test_case_ccon_gradient_square(n_label, n_internal_test_case, n_class, test_case_ccon_gradient_square_list);
}